// File: char_v.h
//
// Description: Include file for the smart character vector class
//
// Copyright 1992, 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library may
//       be used in compiled form without restrictions.  All
//       source rights reserved: Source code to the GUI library
//       can not be distributed (on bulletin boards, or as part
//       of shareware or commercial products) without written
//       permission.
//

#ifndef __char_vect
#define __char_vect

#include <fstream.h>

#define input (ios::in)
#define output (ios::out)

class char_vect {
    char *p;
    long size;
    void grow(long new_size);
    long ub() { return (size - 1); }
  public:
    char_vect(void);
    char_vect (long n);
    char_vect(char_vect &v);
    char_vect(char a[], long n);
   ~char_vect() { /*GlobalFree(handle_p);*/  delete [] p; }
    char /* FAR */ & operator [] (long i);  // range check safeguards
    int save(char * /*filename*/ ) { return 0; };
    int restore(char * /*filename*/ ) { return 0;  };
};

#endif
